import csv
import requests

CSV_PATH = 'PATH_TO/pocket/part_000000.csv'  # getpocket export file
API_URL = 'http://shiori.para.net/api/bookmarks'
HEADERS = {
    'Content-Type': 'application/json',
    'Authorization': 'Bearer TOKEN'
}

def parse_tags(tag_string):
    if not tag_string:
        return []
    return [{"name": tag.strip()} for tag in tag_string.split("|")]

def import_bookmarks(csv_path):
    with open(csv_path, newline='', encoding='utf-8') as csvfile:
        reader = csv.DictReader(csvfile)
        for row in reader:
            payload = {
                "url": row["url"],
                "createArchive": False,
                "public": 0,
                "tags": parse_tags(row["tags"]),
                "excerpt": ""
            }
            print(payload)
            response = requests.post(API_URL, headers=HEADERS, json=payload)
            print(f"Sent: {row['url']} - Status: {response.status_code}")
            

if __name__ == "__main__":
    import_bookmarks(CSV_PATH)